---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ビット演算（Bitwise Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/ops/bitwise_ops.py` - Python実装（全34行、完全読み取り）
- E-02: `tensorflow/core/ops/bitwise_ops.cc` - C++ op定義（全60行、完全読み取り）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bitwise_ops.pyが7つのNotDifferentiable登録を行う | E-01 | ○ |
| C-02 | gen_bitwise_opsのwildcard importが24行目 | E-01 | ○ |
| C-03 | BitwiseAnd, BitwiseOr, BitwiseXorが可換演算 | E-02 | ○ |
| C-04 | LeftShift, RightShiftが非可換演算 | E-02 | ○ |
| C-05 | サポート型がint8/int16/int32/int64/uint8/uint16/uint32/uint64 | E-02 | ○ |
| C-06 | Invert opが23行目で登録 | E-02 | ○ |
| C-07 | PopulationCount opが44行目で登録、出力がuint8 | E-02 | ○ |
| C-08 | BitwiseAnd opが50行目で登録 | E-02 | ○ |
| C-09 | BitwiseOr opが52行目で登録 | E-02 | ○ |
| C-10 | BitwiseXor opが54行目で登録 | E-02 | ○ |
| C-11 | LeftShift opが56行目で登録 | E-02 | ○ |
| C-12 | RightShift opが58行目で登録 | E-02 | ○ |
| C-13 | BINARY_BITWISEマクロが29-34行目で定義 | E-02 | ○ |
| C-14 | BINARY_BITWISE_COMMUTATIVEマクロが36-42行目で定義 | E-02 | ○ |
| C-15 | 二項演算がBroadcastBinaryOpShapeFnを使用 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。ビット演算は小規模なモジュールであり、全ソースコードを完全に読み取り済み。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ソースコードが読み取り済み
- 0: 低リスク - opの数が少なく網羅性が確認しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] bitwise_ops.pyの行番号が現在のソースと一致しているか
- [ ] bitwise_ops.ccの行番号が現在のソースと一致しているか
- [ ] 全7 opが漏れなく記載されているか
